<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ComboItems extends Model 
{

    protected $table = 'combo_items';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function product()
    {
        return $this->belongsTo('Product');
    }

    public function comboItemOption()
    {
        return $this->hasMany('ComboItemOption');
    }

    public function productSize()
    {
        return $this->belongsTo('ProductSize');
    }

}